--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNc3dImport ""
(
  local LOCc3dVspFile
  local LOCc3dVspPath
  local LOCdwgName
  local LOCdwgPath
  local LOCdwgVersion
  local LOCshiftX = 0
  local LOCshiftY = 0
  local LOCshiftZ = 0
  local LOCallowDnSelection = true

  local LOCpopupMenuLV
  local LOCpopupMenuTV

  fn DYNFUNchangeChecked FUNitems FUNsubItemIndex FUNchecked FUNmatchText =
  (
    /*
      FUNitems can be .Items or .SelectedItems
      FUNsubItemIndex can be 0 if checking against ListItem or > 0 if checking against a subItem index
      FUNchecked is the new checked status for the ListItem
      FUNmatchTest is an optionsl "A == B" test. Just set to true if not required.
    */
    for i = 1 to FUNitems.count do
    (
      local LOCitem = FUNitems.item[i-1]
      if LOCitem.tag != "" then
      (
        if FUNsubItemIndex == undefined then
        (
          LOCitem.checked = FUNchecked
          DYNFUNselectVesperObjectForImport DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces LOCitem.tag LOCitem.checked DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
        )
        else
        (
          if FUNmatchText == LOCitem.SubItems.Item[FUNsubItemIndex].text then
          (
            LOCitem.checked = FUNchecked
            DYNFUNselectVesperObjectForImport DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces LOCitem.tag LOCitem.checked DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
          )
        )
      )
    )
  )

  fn DYNFUNmakeC3DpopUpMenuTreeView =
  (
    DYNc3dImport.LOCpopupMenuTV = undefined
    if DYNc3dImport.dnLv.Items.count > 0 then
    (
      rcmenu LOCpopupMenuTV
      (
        menuItem  MNDYNcollapse1  checked:false
        menuItem  MNDYNexpand1    checked:false
        separator MNDYNseparator1

        menuItem  MNDYNselectAll  checked:false
        menuItem  MNDYNselectNone checked:false

        on LOCpopupMenuTV open do
        (
          MNDYNcollapse1.text  = DYNuiResourcesMenus[12]
          MNDYNexpand1.text    = DYNuiResourcesMenus[13]
          MNDYNselectAll.text  = DYNuiResourcesMenus[14]
          MNDYNselectNone.text = DYNuiResourcesMenus[15]

          if DYNc3dImport.dnTree.selectedNode != undefined then
          (
            if DYNc3dImport.dnTree.selectedNode.isExpanded then
            (
              MNDYNcollapse1.enabled = true
              MNDYNexpand1.enabled   = false
            )
            else
            (
              MNDYNcollapse1.enabled = false
              MNDYNexpand1.enabled   = true
            )
          )
          else
          (
            MNDYNcollapse1.enabled = false
            MNDYNexpand1.enabled   = false
          )
        )

        on MNDYNcollapse1 picked do
        (
          local LOCdnRootNode = DYNc3dImport.dnTree.selectedNode

          LOCdnRootNode.collapse()
          for i = 1 to LOCdnRootNode.nodes.count do
          (
            local LOCitem1 = LOCdnRootNode.nodes.item[i-1]
            LOCitem1.collapse()
            for ii = 1 to LOCitem1.nodes.count do
            (
              local LOCitem2 = LOCitem1.nodes.item[ii-1]
              LOCitem2.collapse()
              for iii = 1 to LOCitem2.nodes.count do
              (
                local LOCitem3 = LOCitem2.nodes.item[iii-1]
                LOCitem3.collapse()
                for iiii = 1 to LOCitem3.nodes.count do
                (
                  local LOCitem4 = LOCitem3.nodes.item[iiii-1]
                  LOCitem4.collapse()
                )
              )
            )
          )
        )
        on MNDYNexpand1 picked   do
        (
          local LOCdnRootNode = DYNc3dImport.dnTree.selectedNode

          LOCdnRootNode.expand()
          for i = 1 to LOCdnRootNode.nodes.count do
          (
            local LOCitem1 = LOCdnRootNode.nodes.item[i-1]
            LOCitem1.expand()
            for ii = 1 to LOCitem1.nodes.count do
            (
              local LOCitem2 = LOCitem1.nodes.item[ii-1]
              LOCitem2.expand()
              for iii = 1 to LOCitem2.nodes.count do
              (
                local LOCitem3 = LOCitem2.nodes.item[iii-1]
                LOCitem3.expand()
                for iiii = 1 to LOCitem3.nodes.count do
                (
                  local LOCitem4 = LOCitem3.nodes.item[iiii-1]
                  LOCitem4.expand()
                )
              )
            )
          )
        )

        on MNDYNselectAll picked do
        (
          DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.items undefined true undefined
        )

        on MNDYNselectNone picked do
        (
          DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.items undefined false undefined
        )
      )
    )
  )

  fn DYNFUNmakeC3DpopUpMenuListView =
  (
    DYNc3dImport.LOCpopupMenuLV = undefined
    if DYNc3dImport.dnLv.selectedItems.count > 0 then
    (
      local LOCexe = "rcmenu LOCpopupMenuLV\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll         checked:false\n"
      LOCexe += "  menuItem  MNDYNselectNone        checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  menuItem  MNDYNselectHighAll     checked:false\n"
      LOCexe += "  menuItem  MNDYNselectHighNone    checked:false\n"
      LOCexe += "  separator MNDYNseparator2\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[20] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectNameAll   checked:false\n"
      LOCexe += "    menuItem  MNDYNselectNameNone  checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[21] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll   checked:false\n"
      LOCexe += "    menuItem  MNDYNselectTypeNone  checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[22] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectCorrAll   checked:false\n"
      LOCexe += "    menuItem  MNDYNselectCorrNone  checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[23] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectAssAll    checked:false\n"
      LOCexe += "    menuItem  MNDYNselectAssNone   checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[24] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectLayerAll  checked:false\n"
      LOCexe += "    menuItem  MNDYNselectLayerNone checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenuLV open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectAll.text       = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectNone.text      = DYNuiResourcesMenus[15]\n"
      LOCexe += "    MNDYNselectHighAll.text   = DYNuiResourcesMenus[16]\n"
      LOCexe += "    MNDYNselectHighNone.text  = DYNuiResourcesMenus[17]\n"
      LOCexe += "    MNDYNselectNameAll.text   = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectNameNone.text  = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectTypeAll.text   = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectTypeNone.text  = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectCorrAll.text   = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectCorrNone.text  = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectAssAll.text    = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectAssNone.text   = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectLayerAll.text  = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectLayerNone.text = DYNuiResourcesMenus[19]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.items undefined true undefined\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.items undefined false undefined\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectHighAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.SelectedItems undefined true undefined\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectHighNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.SelectedItems undefined false undefined\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectNameAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 0 true LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectNameNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 0 false LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectTypeAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[1].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 1 true LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectTypeNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[1].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 1 false LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectCorrAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[5].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 5 true LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectCorrNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[5].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 5 false LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAssAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[8].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 8 true LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectAssNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[8].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 8 false LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectLayerAll picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[11].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 11 true LOCname\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectLayerNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCname = DYNc3dImport.dnLv.selectedItems.item[0].SubItems.item[11].text\n"
      LOCexe += "    DYNc3dImport.DYNFUNchangeChecked DYNc3DImport.dnLv.Items 11 false LOCname\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNc3dImport.LOCpopupMenuLV = Execute LOCexe

      registerRightClickMenu DYNc3dImport.LOCpopupMenuLV
    )
  )


  fn DYNFUNresizeC3Dimporter FUNnewSize =
  (
    local rollout_dnOffset = [0,0]
    if FUNnewSize.y < 225 then (FUNnewSize.y = 225; DYNc3dImport.height = 225)
    if FUNnewSize.x < 945 then (FUNnewSize.x = 945; DYNc3dImport.width  = 945)

    rollout_dnOffset                   = [265,114]
    local LOCdnSize                    = FUNnewSize - rollout_dnOffset
    DYNc3dImport.dnsplitter.width  = FUNnewSize.x - 18
    DYNc3dImport.dnsplitter.height = LOCdnSize.y
    DYNc3dImport.BUDYNokok.pos.x   = DYNdefRLsizeC3D.x - 432
    DYNc3dImport.BUDYNapply.pos.x  = DYNdefRLsizeC3D.x - 347
    DYNc3dImport.BUDYNcanc.pos.x   = DYNdefRLsizeC3D.x - 262
    DYNc3dImport.BUDYNopts.pos.x   = DYNdefRLsizeC3D.x - 177
    DYNc3dImport.BUDYNhelp.pos.x   = DYNdefRLsizeC3D.x - 92
    DYNc3dImport.BUDYNokok.pos.y   = FUNnewSize.y - 70
    DYNc3dImport.BUDYNapply.pos.y  = FUNnewSize.y - 70
    DYNc3dImport.BUDYNcanc.pos.y   = FUNnewSize.y - 70
    DYNc3dImport.BUDYNopts.pos.y   = FUNnewSize.y - 70
    DYNc3dImport.BUDYNhelp.pos.y   = FUNnewSize.y - 70
    DYNc3dImport.dnProgress.pos.y  = FUNnewSize.y - 40
    DYNc3dImport.dnProgress.width  = FUNnewSize.x - 19
    DYNc3dImport.dnStatus.pos.y    = FUNnewSize.y - 20
    DYNc3dImport.dnStatus.width    = FUNnewSize.x - 8
    DYNc3dImport.CKDYNfeatureOn.pos.y   = FUNnewSize.y - 67
    DYNc3dImport.DDDYNfeatureList.pos.y = FUNnewSize.y - 70
    DYNc3dImport.BUDYNfeatureEdit.pos.y = FUNnewSize.y - 70
    DYNc3dImport.BUDYNfeatureNew.pos.y  = FUNnewSize.y - 70
    DYNc3dImport.dnSplitter.refresh()
    DYNdefRLsizeC3D = FUNnewSize
  )

  --- Define Rollout Controls
  button BUABOdir width:155 height:20 pos:[8,9]

  dropdownlist DDDYNobjectType  pos:[170,9]  width:160 enabled:false
  button BUABOadd1 width:20 height:20 pos:[332,9] enabled:false iconName:"CivilView/SelectStrings" iconSize:[16,16]
  button BUABOrem1 width:20 height:20 pos:[355,9] enabled:false iconName:"CivilView/DeselectStrings" iconSize:[16,16]
  edittext EDDYNobjectname  pos:[378,11] enabled:false text:"*" width:140
  button BUABOadd2 width:20 height:20 pos:[522,9] enabled:false iconName:"CivilView/UseWildCard" iconSize:[16,16]
  button BUABOrem2 width:20 height:20 pos:[545,9] enabled:false iconName:"CivilView/DeselectWildCard" iconSize:[16,16]

  checkbox CKDYNfeatureOn        pos:[10,658]  width:150
  dropdownlist DDDYNfeatureList  pos:[165,655]  width:175 enabled:false
  button BUDYNfeatureEdit        pos:[343,655]  width:80  height:20
  button BUDYNfeatureNew         pos:[428,655]  width:80  height:20

  dotNetControl  dnSplitter "System.Windows.Forms.SplitContainer"  height:150 width:976 pos:[8,35]
  dotNetControl  dnTree     "System.Windows.Forms.TreeView"        height:150 width:300 pos:[8,35]
  dotNetControl  dnLv       "System.Windows.Forms.ListView"        height:150 width:300 pos:[328,35]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar"     height:14  width:976 pos:[8,685]
  dotNetControl  dnStatus   "System.Windows.Forms.StatusBar"       height:20  width:976 pos:[8,705]

  button BUDYNokok  width:80 pos:[(DYNdefRLsizeC3D.x - 432),655] height:20
  button BUDYNapply width:80 pos:[(DYNdefRLsizeC3D.x - 347),655] height:20
  button BUDYNcanc  width:80 pos:[(DYNdefRLsizeC3D.x - 262),655] height:20
  button BUDYNopts  width:80 pos:[(DYNdefRLsizeC3D.x - 177),655] height:20
  button BUDYNhelp  width:80 pos:[(DYNdefRLsizeC3D.x - 92),655] height:20

  on DYNc3dImport open do
  (
    DYNc3dImport.title      = DYNuiRolloutNames[46]

    DYNFUNresizeC3Dimporter DYNdefRLsizeC3D
    clearSelection()

    LOCc3dVspFile           = undefined

    BUDYNokok.text          = DYNuiResourcesButtons[1]
    BUDYNapply.text         = DYNuiResourcesButtons[2]
    BUDYNopts.text          = DYNuiResourcesButtons[4]
    BUDYNcanc.text          = DYNuiResourcesButtons[3]
    BUDYNhelp.text          = DYNuiResourcesButtons[5]
    BUABOdir.caption        = DYNuiResourcesButtons[6]
    dnStatus.text           = DYNuiResourcesStatusMessages[16]
    LOCc3dVspPath           = rootNode.DYNrootNodeStore.string01;  if LOCc3dVspPath == "" then LOCc3dVspPath = (getdir #import) + "\\*.vsp3d"

    --- Set Up DotNet TreeView
    DYNFUNdnTreeViewStyle dnTree
    dnTree.imageList = DYNdnSmImageList

    --- Set Up DotNet ListView
    DYNFUNdnListViewStyle dnLv true true
    dnLv.AllowColumnReorder = true
    dnLv.sorting            = DYNdnSortOrderClass.ascending
    dnLv.multiSelect        = true
    dnLv.smallImageList     = DYNdnSmImageList
    local LOCcol01 = dnLv.Columns.add DYNuiResourcesLvColumns[30] 150 ; LOCcol01.textalign = DYNdnHorAlignClass.left
    local LOCcol02 = dnLv.Columns.add DYNuiResourcesLvColumns[31] 145 ; LOCcol02.textalign = DYNdnHorAlignClass.center
    local LOCcol03 = dnLv.Columns.add DYNuiResourcesLvColumns[32]  50 ; LOCcol03.textalign = DYNdnHorAlignClass.center
    local LOCcol04 = dnLv.Columns.add DYNuiResourcesLvColumns[33]  80 ; LOCcol04.textalign = DYNdnHorAlignClass.center
    local LOCcol05 = dnLv.Columns.add DYNuiResourcesLvColumns[34]  80 ; LOCcol05.textalign = DYNdnHorAlignClass.center
    local LOCcol06 = dnLv.Columns.add DYNuiResourcesLvColumns[35] 120 ; LOCcol06.textalign = DYNdnHorAlignClass.center
    local LOCcol07 = dnLv.Columns.add DYNuiResourcesLvColumns[36]  77 ; LOCcol07.textalign = DYNdnHorAlignClass.center
    local LOCcol08 = dnLv.Columns.add DYNuiResourcesLvColumns[37]  77 ; LOCcol08.textalign = DYNdnHorAlignClass.center
    local LOCcol09 = dnLv.Columns.add DYNuiResourcesLvColumns[38] 150 ; LOCcol09.textalign = DYNdnHorAlignClass.center
    local LOCcol10 = dnLv.Columns.add DYNuiResourcesLvColumns[39]  80 ; LOCcol10.textalign = DYNdnHorAlignClass.center
    local LOCcol11 = dnLv.Columns.add DYNuiResourcesLvColumns[40]  80 ; LOCcol11.textalign = DYNdnHorAlignClass.center
    local LOCcol12 = dnLv.Columns.add DYNuiResourcesLvColumns[41] 120 ; LOCcol12.textalign = DYNdnHorAlignClass.center

    dnsplitter.suspendLayout()
    dnsplitter.panel1.suspendLayout()
    dnsplitter.panel2.suspendLayout()
    dnsplitter.Orientation      = (dotNetClass "System.Windows.Forms.Orientation").Vertical
    dnsplitter.isSplitterFixed  = true
    dnsplitter.splitterDistance = 235
    dnsplitter.backcolor        = DYNFUNdnColor (((colorMan.getColor #background) as color) * 255)
    dnSplitter.panel1.controls.add dnTree
    dnSplitter.panel2.controls.add dnLv
    dnTree.dock    = DYNdnDockClass.fill
    dnLv.dock = DYNdnDockClass.fill
    dnsplitter.panel1.resumeLayout()
    dnsplitter.panel2.resumeLayout()
    dnsplitter.resumeLayout()
    dnsplitter.panel1.refresh()
    dnsplitter.panel2.refresh()
    dnsplitter.refresh()

    --- Set Up FIS Default
    DYNFUNsetUpFeatureInterpControls DYNc3dImport
  )

  on DYNc3dImport close do
  (
    DYNc3dAlignments              = #()
    DYNc3dCorridorBaselines       = #()
    DYNc3dCorridorRegions         = #()
    DYNc3dCorridorFeatureLines    = #()
    DYNc3dNamedLandFeatureLines   = #()
    DYNc3dUnnamedLandFeatureLines = #()
    DYNc3dSurfaces                = #()
    DYNc3dPointGroups             = #()
    DYNc3dPipeNetworks            = #()
    DYNc3dCorridorSurfaces        = #()
    DYNc3dSites                   = #()
    /*
    The following arrays also get used by VSP3D files, but not in this import panel which only supports Civil 3D content.
    */
    DYNmxPointStrings       = #()
    DYNmxShapeStrings       = #()
    DYNmxSurfaceStrings     = #()
    DYN12dPointStrings      = #()
    DYN12dShapeStrings      = #()
    DYN12dSurfaceStrings    = #()
    DYNxmlPointStrings      = #()
    DYNxmlShapeStrings      = #()
    DYNxmlSurfaceStrings    = #()

    LOCc3dVspPath = undefined
    LOCc3dVspFile = undefined

    dnTree.nodes.clear()
    dnLv.Items.clear()
    DYNFUNonDialogClose()
  )

  on DYNc3dImport resized argPt2 do
  (
    DYNFUNresizeC3Dimporter argPt2
  )

  on DYNc3dImport moved argPt2 do
  (
    DYNc3dLUP = argPt2
  )

  on BUABOdir pressed do
  (
    local LOCtempC3dVspFile = getOpenFileName caption:DYNuiResourcesTitlebars[4] filename:(LOCc3dVspPath) types:DYNuiResourcesFileTypes[5]

    local LOCc3dVspInfo = DYNFUNreadVesperFile LOCtempC3dVspFile

    if LOCc3dVspInfo[1] != undefined then
    (
      dnTree.nodes.clear()
      dnLv.Items.clear()

      LOCc3dVspFile     = LOCc3dVspInfo[1]
      LOCdwgName        = LOCc3dVspInfo[2]
      LOCdwgPath        = LOCc3dVspInfo[3]
      LOCdwgVersion     = LOCc3dVspInfo[4]
      LOCshiftX         = LOCc3dVspInfo[5]
      LOCshiftY         = LOCc3dVspInfo[6]
      LOCshiftZ         = LOCc3dVspInfo[7]

      DYNc3dImport.title = DYNuiRolloutNames[46] + " [" + (filenamefrompath LOCc3dVspFile) + "]"

      if LOCc3dVspInfo[2] != "" then
      (
        --- DN Version
        local LOCdnRootNode    = dnTree.Nodes.add "@|Drawing" (LOCc3dVspInfo[2] + ".dwg") 40 40
        dnTree.selectedNode    = LOCdnRootNode

        --- Populate TreeView
        DYNFUNdisplayPointGroups  dnTree DYNc3dPointGroups
        DYNFUNdisplayPipeNetworks dnTree DYNc3dPipeNetworks
        DYNFUNdisplaySurfaces     dnTree DYNc3dSurfaces
        DYNFUNdisplayAlignments   dnTree DYNc3dAlignments
        DYNFUNdisplaySites        dnTree DYNc3dSites
        DYNFUNdisplayCorridors    dnTree DYNc3dCorridorBaselines DYNc3dCorridorRegions DYNc3dCorridorFeatureLines

        --- Expand DN TreeView Nodes
        LOCdnRootNode.expand()
        for i = 1 to LOCdnRootNode.nodes.count do
        (
          local LOCitem1 = LOCdnRootNode.nodes.item[i-1]
          LOCitem1.expand()
        )

        DYNFUNflagPreviouslyImportedObjects DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
        DYNFUNdisplayVesperListView dnLv dnTree dnTree.selectedNode DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
        dnTree.selectedNode.ensureVisible()
      )
    )
  )

  on dnLv ColumnClick arg do
  (
    /* arg.column (to get to index of selected column) */
    if dnLv.sorting == DYNdnSortOrderClass.none       then
    (
      dnLv.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnLv.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnLv.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnLv.sorting == DYNdnSortOrderClass.descending then dnLv.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnLv.selectedItems.count > 0 then dnLv.selectedItems.item[0].ensureVisible()
  )

  on dnLv MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeC3DpopUpMenuListView()
      if DYNc3dImport.LOCpopupMenuLV != undefined then popupMenu DYNc3dImport.LOCpopupMenuLV
    )
  )

  on dnTree MouseDown arg1 arg2 do
  (
    local LOCnode = dnTree.getNodeAt arg2.x arg2.y
    if LOCnode != undefined then dnTree.selectedNode = LOCnode
    DYNFUNdisplayVesperListView dnLv dnTree LOCnode DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
  )

  on dnTree MouseUp arg1 arg2 do
  (
    if arg2.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeC3DpopUpMenuTreeView()
      if DYNc3dImport.LOCpopupMenuTV != undefined then popupMenu DYNc3dImport.LOCpopupMenuTV
    )
  )

  on dnLv ItemChecked arg do
  (
    if LOCallowDnSelection then
    (
      if arg.item.tag == "" then
      (
        arg.item.checked = false
      )
      else
      (
        DYNFUNselectVesperObjectForImport DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces arg.item.tag arg.item.checked DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
      )
    )
  )

  on BUDYNopts pressed do
  (
    DYNFUNopenPreferencesPanel 6
  )

  on BUDYNokok pressed do
  (
    local LOCimportStatus = false
    if LOCc3dVspFile != undefined then
    (
      LOCimportStatus = DYNFUNprepForImportingVesperFile LOCc3DVspFile LOCshiftX LOCshiftY CKDYNfeatureOn.checked DDDYNfeatureList.selected dnProgress dnStatus
    )
    if LOCimportStatus then
    (
      rootNode.DYNrootNodeStore.string01 = LOCc3DVspFile
      destroyDialog DYNc3dImport
    )
  )

  on BUDYNapply pressed do
  (
    if LOCc3dVspFile != undefined then
    (
      local LOCimportStatus = DYNFUNprepForImportingVesperFile LOCc3DVspFile LOCshiftX LOCshiftY CKDYNfeatureOn.checked DDDYNfeatureList.selected dnProgress dnStatus
      if LOCimportStatus then
      (
        rootNode.DYNrootNodeStore.string01 = LOCc3DVspFile
        DYNFUNdisplayVesperListView dnLv dnTree dnTree.selectedNode DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
      )
    )
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNc3dImport
  )

  on CKDYNfeatureOn changed arg do
  (
    DDDYNfeatureList.enabled = arg
    if DDDYNfeatureList.selection == 0 and DDDYNfeatureList.items.count > 0 then DDDYNfeatureList.selection = 1
    if arg then
    (
      local LOCtempArray = DYNFUNparsePARAMfile (DYNfeatureInterp.DYNFUNfisStringToFullPath DDDYNfeatureList.selected) "4001"
      if LOCtempArray.count == 0 then messagebox DYNuiResourcesErrorsWarnings[17] title:DYNuiResourcesTitlebars[2]
    )
  )

  on DDDYNfeatureList selected arg do
  (
    local LOCtempArray = DYNFUNparsePARAMfile (DYNfeatureInterp.DYNFUNfisStringToFullPath DDDYNfeatureList.selected) "4001"
    if LOCtempArray.count == 0 then messagebox DYNuiResourcesErrorsWarnings[17] title:DYNuiResourcesTitlebars[2]
  )

  on BUDYNfeatureNew pressed do (macros.run "Civil View" "MCRfeatureInterp")
  on BUDYNfeatureEdit pressed do
  (
    macros.run "Civil View" "MCRfeatureInterp"
    if DDDYNfeatureList.items.count > 0 and DDDYNfeatureList.selection > 0 then
    (
      DYNfeatureInterp.DYNFUNopenFeatureInterpStyle DDDYNfeatureList.selected 1
    )
  )

  on BUABOadd1 pressed do
  (
    DYNFUNchangeChecked dnLv.items 1 true DDDYNobjectType.selected
  )

  on BUABOrem1 pressed do
  (
    DYNFUNchangeChecked dnLv.items 1 false DDDYNobjectType.selected
  )

  on BUABOadd2 pressed do
  (
    if EDDYNobjectname.text != "" then
    (
      for i = 1 to dnLv.items.count do
      (
        local LOCitem = dnLv.items.item[i-1]
        if LOCitem.tag != "" then
        (
          if DDDYNobjectType.selected == LOCitem.SubItems.Item[1].text then
          (
            if (matchPattern LOCitem.text pattern:EDDYNobjectname.text ignoreCase:true) then
            (
              LOCitem.checked = true
              DYNFUNselectVesperObjectForImport DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces LOCitem.tag LOCitem.checked DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
            )
          )
        )
      )
    )
  )

  on BUABOrem2 pressed do
  (
    if EDDYNobjectname.text != "" then
    (
      for i = 1 to dnLv.items.count do
      (
        local LOCitem = dnLv.items.item[i-1]
        if LOCitem.tag != "" then
        (
          if DDDYNobjectType.selected == LOCitem.SubItems.Item[1].text then
          (
            if (matchPattern LOCitem.text pattern:EDDYNobjectname.text ignoreCase:true) then
            (
              LOCitem.checked = false
              DYNFUNselectVesperObjectForImport DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dSurfaces DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines DYNc3dCorridorSurfaces LOCitem.tag LOCitem.checked DYNc3dPointGroups DYNc3dAlignments DYNc3dPipeNetworks
            )
          )
        )
      )
    )
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13210 -- id_cv_import_civil_3d
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB+UgptieVh250NsaTQaGkhy1FgViZ9DGE2
-- uJo55ZbEOsEcaTDfQJqsOl7/bjUr1CegeChQoGjL4Y+zYtOUR2zBV9u+MeKKfMIZ
-- zhdRZQiaSlkXov0Tp/AAH/LXa/TwThMIT4ZwUyP9BwxWulpHpnShZHy3M/UhKtl9
-- XHg45hN4gHAz1zsnQiQuRAXTBh7oeEQhPdmVBxxnoHhV8DCU7qUG9ChoD/LvgIU9
-- 6BackPOp4bX07xMsw3cd6t25TepVhsQjmYZhRQQonCRchCbpALo1qqRKxaMancuv
-- 25jeEJ9xbOy0VoNbD4533ns4Wm/YQ1mGAU4oTKsGBsvqW2OeCx83
-- -----END-SIGNATURE-----